<?php
/**
 * Display the breadcrumb automatically
 * 
 * @param  String $custom_home_icon  [OPTIONAL] Insert html tag (like Fontawesome <i class="fa fa-xx"></li>)
 * @param  Array $custom_post_types [OPTIONAL] Prevent custom post types with hierarchical structure
 */
function bootstrap_breadcrumb($custom_home_icon = false, $custom_post_types = false) 
{
	wp_reset_query();
	global $post;
	$is_products = false;

	if ($post->post_type != "page" && !is_search()) {
		if ($post->post_type === "products") {
			$is_products = true;
			/* get_post_type_object( get_post_type($post) )->name; */
			$linguaCorrente = ICL_LANGUAGE_CODE.'/';
			if ($linguaCorrente == "en/"){
				$linguaCorrente = "";
			}
			$post_type_pre = '<li class="breadcrumb-item"><a href="/'.$linguaCorrente.strtolower(__("Products", "breadcumbs")).'/">'.__("Products", "microtest").'</a></li>';
		}
		else $post_type_pre = '<li class="breadcrumb-item">'.__(get_post_type_object( get_post_type($post) )->label, "microtest").'</li>';
	}
	
	$is_custom_post = $custom_post_types ? is_singular( $custom_post_types ) : false;
	
	if (!is_front_page() && !is_home()/*  && !is_search() */) {	// Elemento 1 Home
		$translated_page_home = icl_object_id(470, 'page', true); // 470 è l'ID della pagina home
		$url_pagina_home = get_permalink( $translated_page_home );
		echo '<ol class="breadcrumb">';
		echo '<li class="breadcrumb-item"><a href="'.$url_pagina_home.'">';
		_e("Home", "microtest");
		echo "</a></li>";

		/*
		attivando qeusta linea varrà rimosso il link alla categoria
		 if ( has_category()  && !is_single() ) { */
		if ( has_category() && is_single() && (get_the_category($post->ID)[0]->name != "News") && (get_the_category($post->ID)[0]->name != "Events")) {
			echo '<li class="breadcrumb-item active"><a href="'.esc_url( get_permalink( get_page( get_the_category($post->ID) ) ) ).'">';
			the_category(', ');
			/* echo get_the_category($post->ID)[0]->name === "News"; */
			echo '</a></li>';
		}

		// Se sono nelle categorie stampo anche il parent e la categoria selezionata
		if (is_tax()) {
			echo $post_type_pre;
			$term = get_queried_object();
			echo '<li class="breadcrumb-item active">'.$term->name.'</li>';
		}

		if ( is_category() || is_single() || $is_custom_post ) {  
			if ( is_category() && !is_single() && get_post_type($post) != "post") echo '<li class="breadcrumb-item active"><a href="'.esc_url( get_permalink( get_page( get_the_category($post->ID) ) ) ).'">'.get_the_category($post->ID)[0]->name.'</a></li>'; 
			else{
				if (get_the_category($post->ID)[0]->name === "News"){
					$translated_page_news = icl_object_id(712, 'page', true); // 712 è l'ID della pagina News
					$url_pagina_news = get_permalink( $translated_page_news );
					echo '<li class="breadcrumb-item"><a href="'.$url_pagina_news.'">'.__("News", "microtest").'</a></li>'; 
				} else if (get_the_category($post->ID)[0]->name === "Events"){
					echo '<li class="breadcrumb-item">'.__("Events", "microtest").'</li>'; 
				}
			}
			
      if ( $is_custom_post ) {
				echo  '<li class=" breadcrumb-itemactive"><a href="'.get_option('home').'/'.get_post_type_object( get_post_type($post) )->name.'">'.get_post_type_object( get_post_type($post) )->label.'</a></li>';

				if ( $post->post_parent ) 
				{
					$home = get_page(get_option('page_on_front'));
					for ($i = count($post->ancestors)-1; $i >= 0; $i--) 
					{
						if (($home->ID) != ($post->ancestors[$i])) {
							echo 'PARENT<li class="breadcrumb-item"><a href="';
							echo get_permalink($post->ancestors[$i]); 
							echo '">';
							echo get_the_title($post->ancestors[$i]);
							echo "</a></li>";
						}
					}
				}
			}

			if ( is_single()) {
				if (get_post_type($post) != "post"){
					echo $post_type_pre.'<li class="breadcrumb-item active">'.get_the_title($post->ID).'</li>';
				} else {
					echo '<li class="breadcrumb-item active"> '.get_the_title($post->ID).'</li>';
				}
			}	
            
		} elseif ( is_page() && $post->post_parent ) 
		{ // Qui ci sono le pagine con il parent page (solo servizi lo ha)
			$home = get_page(get_option('page_on_front'));

			for ($i = count($post->ancestors)-1; $i >= 0; $i--) 
			{
				if (($home->ID) != ($post->ancestors[$i])) 
				{
					echo '<li class="breadcrumb-item">';
					/* echo '<a href="'.get_permalink($post->ancestors[$i]);'">';
					echo get_the_title($post->ancestors[$i]);
					echo "</a>"; */
					echo get_the_title($post->ancestors[$i]);
					echo "</li>";
				}
			}

			echo '<li class="breadcrumb-item active">'.get_the_title($post->ID).'</li>';
		} elseif (is_page()) {
			// Per tutte le pagine senza parent page
			echo '<li class="breadcrumb-item active">'.get_the_title($post->ID).'</li>';
		} elseif (is_404()) {
			echo '<li class="breadcrumb-item active">404</li>';
		} elseif (!is_tax()) {
			if ($is_products && !is_search() ) {
				//Stampa Products per la pagina archive-products.php
				echo '<li class="breadcrumb-item active">'.__("Products", "microtest").'</li>';
			} elseif (is_search()) {
				echo $post_type_pre.'<li class="breadcrumb-item active">';
				_e(" Search ", "microtest");
				echo '</li>';
			}
		} 
		echo '</ol>';
	}
}