<?php

/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Bootscore
 */

global $post;
$pID = $post->ID;
$stampa = $pID==762||$pID==1567||$pID==1566;
?>
<!doctype html>
<html <?php language_attributes(); ?>>

<head>
  <meta charset="<?php bloginfo('charset'); ?>">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="profile" href="https://gmpg.org/xfn/11">
  <!-- Favicons -->
  <link rel="apple-touch-icon" sizes="180x180" href="<?php echo get_stylesheet_directory_uri(); ?>/img/favicon/apple-touch-icon.png">
  <link rel="icon" type="image/png" sizes="32x32" href="<?php echo get_stylesheet_directory_uri(); ?>/img/favicon/favicon-32x32.png">
  <link rel="icon" type="image/png" sizes="16x16" href="<?php echo get_stylesheet_directory_uri(); ?>/img/favicon/favicon-16x16.png">
  <link rel="mask-icon" href="<?php echo get_stylesheet_directory_uri(); ?>/img/favicon/safari-pinned-tab.svg" color="#0d6efd">
  <meta name="msapplication-TileColor" content="#ffffff">
  <meta name="theme-color" content="#ffffff">
  <?php wp_head(); ?>
</head>

<!-- Google tag (gtag.js) -->
<?php /* guida anonymizing ip https://complianz.io/are-your-ip-addresses-anonymized/  */?>
<script async src="https://www.googletagmanager.com/gtag/js?id=G-2Q3RJ0549T"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-2Q3RJ0549T',{ 
    'anonymize_ip': true,
    cookie_flags:'secure;samesite=none' });
</script>

<body <?php body_class(); ?>>
  <?php wp_body_open(); ?>
  <div id="to-top"></div>
  <div id="page" class="site" <?= $stampa?'style="background-color:#f2f2f2"':'' ?>>
    <header id="masthead" class="site-header">
      <?php $linguaAttuale = ICL_LANGUAGE_CODE; ?>
      <div class="fixed-top <?= $linguaAttuale ?>">
        <nav id="nav-main" class="navbar navbar-expand-xl navbar-light">
          <div class="container">
            <!-- Navbar Brand -->
            <div class="logoMicrotestContainer">
              <a class="navbar-brand xs d-md-none" href="<?php echo esc_url(home_url()); ?>"><img src="<?php echo esc_url(get_stylesheet_directory_uri()); ?>/img/logo/logo_microtest.svg" alt="logo" class="logo xs"></a>
             <a class="navbar-brand md d-none d-md-block" href="<?php echo esc_url(home_url()); ?>"><img src="<?php echo esc_url(get_stylesheet_directory_uri()); ?>/img/logo/logo_microtest.svg" alt="logo" class="logo md"></a>
             <?php 
              $translated_page_about_us = icl_object_id(24, 'page', true); // 24 è l'ID della pagina about us
              $url_pagina_about_us = get_permalink( $translated_page_about_us );
             ?>
             
             <a class="loghetto-anniversario ingrandito d-none d-md-flex" href="<?= $url_pagina_about_us; ?>/#history">
                <!-- Set up -->
                <video loop="" muted="" width="100" height="80" autoplay="" playsinline="" class="video-anniversario">
                  <!-- Provide the Safari video -->
                    <source src="<?php echo esc_url(get_stylesheet_directory_uri()); ?>/img/anniversario/Microtest_25esimo_logo_finale_200x160_allungato-hevc-safari.mp4"  type='video/mp4; codecs="hvc1"'> 
                    <source src="<?php echo esc_url(get_stylesheet_directory_uri()); ?>/img/anniversario/Microtest_25esimo_logo_finale_200x160_allungato-vp9-chrome.webm" type="video/webm">
                </video>
              </a>
            </div>

            <!-- Offcanvas Navbar -->
            <div class="offcanvas offcanvas-end" tabindex="-1" id="offcanvas-navbar">
              <div class="offcanvas-header">
                <span class="h5 mb-0"><?php esc_html_e('Menu', 'bootscore'); ?></span>
                <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
              </div>
              <div class="offcanvas-body">
                <!-- Bootstrap 5 Nav Walker Main Menu -->
                <?php
                  wp_nav_menu(array(
                    'theme_location' => 'main-menu',
                    'container' => false,
                    'menu_class' => '',
                    'fallback_cb' => '__return_false',
                    'items_wrap' => '<ul id="microtest-navbar" class="navbar-nav ms-auto %2$s">%3$s</ul>',
                    'depth' => 5,
                    'walker' => new bootstrap_5_wp_nav_menu_walker()
                  ));
                ?>
                <!-- Bootstrap 5 Nav Walker Main Menu End -->
                <a class="loghetto-anniversario ingrandito d-md-none" href="<?= $url_pagina_about_us; ?>/#history" style="margin-top: 20px">
                  <!-- Set up -->
                  <video loop="" muted="" width="100" height="80" autoplay="" playsinline="" class="video-anniversario">
                    <!-- Provide the Safari video -->
                    <source src="<?php echo esc_url(get_stylesheet_directory_uri()); ?>/img/anniversario/Microtest_25esimo_logo_finale_200x160_allungato-hevc-safari.mp4"  type='video/mp4; codecs="hvc1"'> 
                    <source src="<?php echo esc_url(get_stylesheet_directory_uri()); ?>/img/anniversario/Microtest_25esimo_logo_finale_200x160_allungato-vp9-chrome.webm" type="video/webm">
                  </video>
                </a>
              </div>
            </div>

            <div class="header-actions d-flex align-items-center">
                  
                <div class="linkSocial">
                  <ul>
                    <li>
                      <a target="_blank" href="https://www.youtube.com/channel/UCU4iszH8uOxxKQF3DIZMHUQ"><i class="fab fa-youtube"></i></a>
                    </li>
                    <li class="">
                      <a target="_blank" href="https://it.linkedin.com/company/microtest-srl/"><i class="fab fa-linkedin-in"></i></a>
                    </li>
                  </ul>
                </div>

                <div class="lenteApriRicerca">
                  <i class="fas fa-search"></i>
                </div>

              <!-- Navbar Toggler -->
              <button class="mostraNavbarMobile btn d-xl-none ms-1 ms-md-2" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvas-navbar" aria-controls="offcanvas-navbar">
                <i class="fas fa-bars"></i>
              </button>

              <!-- LANG SWITCHER -->
          <div class="langSwitcher">
              <?php 
                function get_custom_lang_code_func() {
                    $languages = apply_filters( 'wpml_active_languages', NULL, 'orderby=code&order=desc' );
                    if(!empty($languages)){
                        //$content = '<ul id="select_lang_switch">';
                            $content = '';
                            foreach($languages as $l){
                                /* var_dump($l); */
                                  if($l['language_code']){
                                      $selected = '';
                                      if ($l['language_code'] == "zh-hans") {
                                        $codiceLingua = "中文";
                                      } else {
                                        $codiceLingua = $l['language_code'];
                                      }
                                      if($l['active'])
                                        $selected = "active";
                                    $content .= '<li class="'.$selected. ' wpml-ls-item"><a href="'.$l['url'].'">'.$codiceLingua.'</a></li>';
                                  }
                            }
                        $content .= '';
                    }
                    return $content;
                }
              ?>  
              <ul>
                <?php echo get_custom_lang_code_func(); ?>
              </ul>
              <?php /* do_action('wpml_add_language_selector'); */ ?> 
            </div>
            </div><!-- .header-actions -->
          </div><!-- .container -->

          <!-- Searchform Large -->
          <div class="barraRicerca">
            <div class="container">
              <div class="searchBarForm">
                <?php if (is_active_sidebar('top-nav-search')) : ?>
                    <?php dynamic_sidebar('top-nav-search'); ?>
                <?php endif; ?>
              </div>
              <div class="chiudiSearchBar">
                <button type="button" class="btn-close" aria-label="Close"></button>
              </div>
            </div>
          </div>
        </nav><!-- .navbar -->

        <!-- Top Nav Search Mobile Collapse -->
        <div class="collapse container d-lg-none" id="collapse-search">
          <?php if (is_active_sidebar('top-nav-search')) : ?>
            <div class="mb-2">
              <?php dynamic_sidebar('top-nav-search'); ?>
            </div>
          <?php endif; ?>
        </div>
      </div><!-- .fixed-top .bg-light -->

      <div id="breadcrumbs">
        <?php if( function_exists('bootstrap_breadcrumb') ): ?>
          <section class="section-breadcrumb">
            <div class="container">
              <?php bootstrap_breadcrumb('Home'); ?>
            </div>
          </section>
        <?php endif; ?>
      </div>

    </header><!-- #masthead -->

    <?php //bootscore_ie_alert();