<?php

/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package Bootscore
 */

get_header();
?>
<div id="content" class="site-content paginaRicerca">
  <div class="container">
    <div id="primary" class="content-area">
      <div class="row">
        <div class="col">
  
          <main id="main" class="site-main">
  
            <?php if (have_posts()) : ?>
  
              <header class="page-header">
                <h1>
                  <?php
                  /* translators: %s: search query. */
                  printf(esc_html__('Search Results for: %s', 'bootscore'), '<span class="text-searched">' . get_search_query() . '</span>');
                  ?>
                </h1>
              </header>
              <div class="contieniRisultati">
                <div class="row">
                    <?php
                      /* Start the Loop */
                      while (have_posts()) :
                        the_post();
          
                        ?>
                        <a href="<?php echo get_permalink() ?>" class="singleResult col-12 col-sm-6 col-md-4 ">
                          <div class="contenuto">
                            <div class="immagine">
                              
                              <?php if (get_the_post_thumbnail_url())  {?>
                              <img src="<?= get_the_post_thumbnail_url(); ?>">
                              <?php } else { ?>
                                <img src="<?php echo esc_url(get_stylesheet_directory_uri()); ?>/img/logo/logo_microtest-pacific.svg">
                              <?php } ?>
                            </div>
                            <div class="testo">
                              <div class="titolo">
                                <?= get_the_title() ?>
                              </div>                          
                              <!-- <div class="exerpt">
                                <?php echo get_field('short_description'); ?>
                              </div> -->
                              <div class="readMore">
                                <p><?php _e("Read more", "microtest"); ?></p>
                              </div>
                            </div>
                          </div>
                        </a>
                      <?php
                      endwhile;
                      bootscore_pagination();
          
                    else :
                      get_template_part('template-parts/content', 'none');
                    endif;
                    ?>
                </div>
              </div>
          </main><!-- #main -->
  
        </div><!-- col -->
      </div><!-- row -->
  
    </div><!-- #primary -->
  </div>
</div><!-- #content -->
<?php
get_footer();
