<?php

namespace {
    /**
     * Array-based data source for HTML_QuickForm2 objects
     *
     * PHP version 5
     *
     * LICENSE:
     *
     * Copyright (c) 2006-2010, Alexey Borzov <avb@php.net>,
     *                          Bertrand Mansion <golgote@mamasam.com>
     * All rights reserved.
     *
     * Redistribution and use in source and binary forms, with or without
     * modification, are permitted provided that the following conditions
     * are met:
     *
     *    * Redistributions of source code must retain the above copyright
     *      notice, this list of conditions and the following disclaimer.
     *    * Redistributions in binary form must reproduce the above copyright
     *      notice, this list of conditions and the following disclaimer in the
     *      documentation and/or other materials provided with the distribution.
     *    * The names of the authors may not be used to endorse or promote products
     *      derived from this software without specific prior written permission.
     *
     * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
     * IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
     * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
     * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
     * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
     * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
     * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
     * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
     * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
     * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
     * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
     *
     * @category   HTML
     * @package    HTML_QuickForm2
     * @author     Alexey Borzov <avb@php.net>
     * @author     Bertrand Mansion <golgote@mamasam.com>
     * @license    http://opensource.org/licenses/bsd-license.php New BSD License
     * @version    SVN: $Id: Array.php 294057 2010-01-26 21:10:28Z avb $
     * @link       http://pear.php.net/package/HTML_QuickForm2
     */
    /**
     * Interface for data sources used by HTML_QuickForm2 objects
     */
    // require_once 'HTML/QuickForm2/DataSource.php';
    /**
     * Array-based data source for HTML_QuickForm2 objects
     *
     * @category   HTML
     * @package    HTML_QuickForm2
     * @author     Alexey Borzov <avb@php.net>
     * @author     Bertrand Mansion <golgote@mamasam.com>
     * @version    Release: @package_version@
     */
    class HTML_QuickForm2_DataSource_Array implements \HTML_QuickForm2_DataSource
    {
        /**
         * Array containing elements' values
         * @var array
         */
        protected $values;
        /**
         * Class constructor, initializes the values array
         *
         * @param    array   Array containing the elements' values
         */
        public function __construct($values = array())
        {
            $this->values = $values;
        }
        public function getValue($name)
        {
            if (empty($this->values)) {
                return null;
            }
            if (\strpos($name, '[')) {
                $tokens = \explode('[', \str_replace(']', '', $name));
                $value = $this->values;
                do {
                    $token = \array_shift($tokens);
                    if (!isset($value[$token])) {
                        return null;
                    }
                    $value = $value[$token];
                } while (!empty($tokens));
                return $value;
            } elseif (isset($this->values[$name])) {
                return $this->values[$name];
            } else {
                return null;
            }
        }
    }
}
