<?php

/**
 * Matomo - free/libre analytics platform
 *
 * @link    https://matomo.org
 * @license https://www.gnu.org/licenses/gpl-3.0.html GPL v3 or later
 */
namespace Piwik\Plugins\Actions\Reports;

use Piwik\DbHelper;
use Piwik\Piwik;
use Piwik\Plugin\ViewDataTable;
use Piwik\API\Request;
use Piwik\Plugins\Actions\Columns\PageTitle;
use Piwik\Plugins\Actions\Columns\Metrics\AveragePageGenerationTime;
use Piwik\Plugins\Actions\Columns\Metrics\AverageTimeOnPage;
use Piwik\Plugins\Actions\Columns\Metrics\BounceRate;
use Piwik\Plugins\Actions\Columns\Metrics\ExitRate;
use Piwik\Plugin\ReportsProvider;
class GetPageTitles extends \Piwik\Plugins\Actions\Reports\Base
{
    protected function init()
    {
        parent::init();
        $this->dimension = new PageTitle();
        $this->name = Piwik::translate('Actions_SubmenuPageTitles');
        $this->documentation = Piwik::translate('Actions_PageTitlesReportDocumentation', ['<br />', htmlentities('<title>', ENT_COMPAT | ENT_HTML401, 'UTF-8')]);
        $this->order = 5;
        $this->metrics = array('nb_hits', 'nb_visits');
        $this->processedMetrics = array(new AverageTimeOnPage(), new BounceRate(), new ExitRate(), new AveragePageGenerationTime());
        $this->actionToLoadSubTables = $this->action;
        $this->subcategoryId = 'Actions_SubmenuPageTitles';
        $this->hasGoalMetrics = true;
    }
    public function getMetrics()
    {
        $metrics = parent::getMetrics();
        $metrics['nb_visits'] = Piwik::translate('General_ColumnUniquePageviews');
        return $metrics;
    }
    protected function getMetricsDocumentation()
    {
        $metrics = parent::getMetricsDocumentation();
        $metrics['nb_visits'] = Piwik::translate('General_ColumnUniquePageviewsDocumentation');
        $metrics['bounce_rate'] = Piwik::translate('General_ColumnPageBounceRateDocumentation');
        return $metrics;
    }
    public function configureView(ViewDataTable $view)
    {
        $view->config->self_url = Request::getCurrentUrlWithoutGenericFilters(array('module' => $this->module, 'action' => 'getPageTitles'));
        $view->config->title = $this->name;
        $view->config->columns_to_display = array('label', 'nb_hits', 'nb_visits', 'bounce_rate', 'avg_time_on_page', 'exit_rate');
        if (version_compare(DbHelper::getInstallVersion(), '4.0.0-b1', '<')) {
            $view->config->columns_to_display[] = 'avg_time_generation';
        }
        $this->addPageDisplayProperties($view);
        $this->addBaseDisplayProperties($view);
        $view->config->show_goals = true;
    }
    public function getRelatedReports()
    {
        return array(ReportsProvider::factory('Actions', 'getEntryPageTitles'), ReportsProvider::factory('Actions', 'getExitPageTitles'));
    }
}
