<?php
 /**
  * Template Name: Firma Template
  * @link https://codex.wordpress.org/Template_Hierarchy
  * @package Microtest
  */

get_header();
/* per evitare la cache di w3cache https://wordpress.org/support/topic/disable-caching-for-a-specific-page/ */
define('DONOTCACHEPAGE', true);
?> 
 
<style>
    #nav-main .loghetto-anniversario,
    #nav-main .offcanvas.offcanvas-end,
    #nav-main .header-actions{
        display: none!important;
        width: 0;
        height:0;
        overflow: hidden;
        opacity: 0;
        cursor-events: none;
    }
    #nav-main .container{
        justify-content: center;
    }
    #page{
        background-color: rgb(220, 240, 227);
    }
    #breadcrumbs{
        opacity: 0;
        cursor-events: none;
        max-height: 0;
        padding: 0;
        overflow: hidden;
    }
    #main{
        display: flex;
        align-items: center;
        justify-content: center;
        /* text-align: center; */
        flex-direction: column;
    }
    #main .container{
        display: flex;
        align-items: center;
        justify-content: center;
        flex-direction: column;
    }
    #main h1{
        padding: 35px 0 30px;
        margin: 0;
    }

    .immagine-inclusa{
      display: none;
    }
    .immagine-inclusa.si{
      display: block;
    }

</style>

<?php
$banner = array(
  'immagine' => 'https://www.microtest.net/firmamail/banner/firma-twepp-2024-min.png',
  'alt' => 'Microtest Group at TWEPP 2024 – Advancing Electronics for Particle Physics - September 30th to October 4th, 2024',
  'link' => 'https://twepp24.org/'
);
?>

<main id="main" class="firma">
    <div class="container">
      <div class="row">
        <div class="col-12">
          <h1>Inserisci i dati per generare la tua firma</h1>
          <div class="gestione-input">            
            <input type="text" id="name" name="name" placeholder='Nome e Cognome'>
            <input type="text" id="ruolo" name="ruolo" placeholder='Ruolo'>
            <input type="text" id="interno" name="interno" placeholder='Interno' maxlength="5">
            <input type="text" id="cellulare" name="cellulare" placeholder='Cellulare' maxlength="15">
          </div>
        </div>
        <div class="inclusione-immagine" style="margin-top: 10px;">
          <input type="checkbox" id="immagine-banner-firma" name="immagine-banner-firma">
          <label for="immagine-banner-firma">Includi Immagine Evento</label>
        </div>
        <div class="col-md-12 anteprima-grafica">
          <div class="anteprima-firma">
            Anteprima della tua firma:
          </div>
          <div class="anteprima-grafica-firma">
             <table cellspacing="0" cellpadding="0" border="0">
              <tr>
                <td width="" valign="top" style="padding-left: 0px; padding-top: 0px; padding-bottom: 0px; padding-right: 0px;">
                <span style="text-align: left; color: #4A4A4A; font-family: 'Barlow', Arial, sans-serif; font-size: 14pt; font-weight: bold; font-style: normal;" id="nome-cognome-value" class='poi-evidenziato'><font face="'Barlow', Arial, sans-serif;">Nome e Cognome</font></span><br>
                <span style="text-align: left; margin-top: 0px; margin-bottom: 0px; color: #4A4A4A; font-family: 'Barlow', Arial, sans-serif; font-weight: normal; font-size: 12pt;" id="ruolo-value" class='poi-evidenziato'><font face="'Barlow', Arial, sans-serif;">Ruolo</font></span><br>
                </td>
              </tr>
              <tr>
                <td valign="top" style="padding-left: 0px; padding-top: 15px; padding-bottom: 10px; padding-right: 0px;">
                <a href="http://www.microtest.net/" target="_blank"><img src="https://www.microtest.net/firmamail/Microtest_Firma_mail_payoff.png" nosend="1" border="0" width="250" alt="Microtest" title="Microtest"></a>
                </td>
              </tr>

              <tr>
                <td valign="top" style="padding-left: 0px; padding-top: 0px; padding-bottom: 0px; padding-right: 0px;">
                  <span style="text-align: left; color: #4A4A4A; font-family: 'Barlow', Arial, sans-serif; font-size: 9pt; font-style: normal; font-weight: normal;">Via della Galeotta 9/A <span style="color:#009739;text-align: left; font-family: 'Barlow', Arial, sans-serif; font-size: 9pt; font-style: normal; font-weight: normal;">|</span>  55011 – Altopascio, Lucca – Italy <br>
                  <span style="color:#009739;text-align: left; font-family: 'Barlow', Arial, sans-serif; font-size: 9pt; font-style: normal; font-weight: normal;"> direct phone </span> <a href="tel:+390583269651" target="_blank" style="color: #4A4A4A; text-decoration: none; font-size: 9pt; font-family: 'Barlow', Arial, sans-serif;"><font face="'Barlow', Arial, sans-serif;">+39 0583 269651</font></a> 
                  <span class="mostra-esterno nascondi">ext. <span id="interno-value" class='poi-evidenziato' style="text-align: left; color: #4A4A4A; font-family: 'Barlow', Arial, sans-serif; font-size: 9pt; font-style: normal; font-weight: normal;">XX</span> </span> 
                  <span class="mostra-mobile nascondi"> <span style="color:#009739;text-align: left; font-family: 'Barlow', Arial, sans-serif; font-size: 9pt; font-style: normal; font-weight: normal;">| mobile&nbsp;</span>(+39)&nbsp;<a href="tel:+39XXX XXXXXXX" id="link-cellulare" style="color: #4A4A4A; text-decoration: none; font-size: 9pt; font-family: 'Barlow', Arial, sans-serif;" target="_blank"><font face="'Barlow', Arial, sans-serif;"><span id="numero-cellulare-value"  class='poi-evidenziato' style="text-align: left; color: #4A4A4A; font-family: 'Barlow', Arial, sans-serif; font-size: 9pt; font-style: normal; font-weight: normal;">XXX XXXXXXX</span></font></a></span>
                </span>
                </td>
              </tr>

              <tr>
                <td valign="top" style="padding-left: 0px; padding-top: 10px; padding-bottom: 0px; padding-right: 0px;"><table width="" border="0">
                    <tr>
                      <td width="30" align="left"><a href="https://www.linkedin.com/company/microtest-srl/" target="_blank"><img src="https://www.microtest.net/firmamail/Microtest_Firma_mail_payoff-linkedin.png" alt="LinkedIn" width="20" height="20" border="0"></a></td>
                      <td width="30" align="left"><a href="http://www.youtube.com/c/Microtestmovies" target="_blank"><img src="https://www.microtest.net/firmamail/Microtest_Firma_mail_payoff-youtube.png"  alt="YouTube" width="20" height="20" border="0"></a></td>
                      <td><a style="text-decoration: none; color: #009739; font-family: 'Barlow', Arial, sans-serif; font-style: 13; font-weight: bold; valign: centre;" href="http://www.microtest.net" target="_blank"><font color="#009739" face="'Barlow', Arial, sans-serif;">www.microtest.net</font></a> </td>
                    </tr>
                </table>
                <table width="" border="0" style="margin-top: 20px;padding-top:10px" class="immagine-inclusa">
                    <tr>
                      <td>
                        <a style="text-decoration: none; color: #009739; font-family: 'Barlow', Arial, sans-serif; font-style: 13; font-weight: bold; valign: centre;" href="<?php echo $banner['link'] ?>" target="_blank">
                          <img src="<?php echo $banner['immagine'] ?>" width="500" height="156" style="width:500px; height:150px;" alt="<?php echo $banner['alt'] ?>">
                        </a>
                    </td>
                    </tr>
                </table>  
                  <hr noshade="noshade" color="#009739">
                </td>
              </tr>


              <tr>
                <td valign="top" style="padding-left: 0px; padding-top: 0px; padding-bottom: 0px; padding-right: 0px;">
                <span style="color: #8A8A8A; font-family: 'Barlow', Arial, sans-serif; font-size: 8pt; font-weight: regular;"><font color="#8A8A8A" face="'Barlow', Arial, sans-serif;">This email and any files attached are proprietary, confidential and intended exclusively for use by the individual or entity to whom they are dispatched. <br/>
                If you are not the intended recipient, please delete the email and notify the sender.</font></span>
                </td>
              </tr>

            </table>
          </div>
        </div>
        <div class="col-12 scarica-firma">
          <button id="scarica-la-tua-firma">Scarica la firma</button>
        </div>
        
      </div>
    </div>
</main>

<script>
  jQuery(document).ready(function($) {
     $('.gestione-input').on('change, keyup', function(){
      let nomeInserito = $('input[name="name"]').val();
      let ruoloInserito = $('input[name="ruolo"]').val();
      let internoInserito = $('input[name="interno"]').val();
      let cellulareInserito = $('input[name="cellulare"]').val();
      if (nomeInserito) {
        $('#nome-cognome-value').html(nomeInserito);
      } else {
        $('#nome-cognome-value').html('Nome Cognome');
      }      
      if (ruoloInserito) {
        $('#ruolo-value').html(ruoloInserito);
      } else {
        $('#ruolo-value').html('Ruolo');
      }      
      if (internoInserito) {
        $('#interno-value').html(internoInserito);
        $('.mostra-esterno').removeClass('nascondi');
      } else {
        $('#interno-value').html('XX');
        $('.mostra-esterno').addClass('nascondi');
      }      
      if (cellulareInserito) {
        /* console.log(cellulareInserito.length); */
        if (cellulareInserito.length < 16) {
          $('#numero-cellulare-value').html(cellulareInserito);
        }
        $('.mostra-mobile').removeClass('nascondi')
      } else {
        $('#numero-cellulare-value').html('XXX XXXXXXX');
        $('.mostra-mobile').addClass('nascondi')
      }

      /* evidenziazzione campi nella firma */
      

     })     
     $('#immagine-banner-firma').on('change', function(){
        if($(this).is(':checked')){
          $('.immagine-inclusa').addClass('si');
        } else {
          $('.immagine-inclusa').removeClass('si');
        }
     })

     $('.gestione-input input').on('focus', function(){
        if($('input[name="name"]:focus').length){
          $('#nome-cognome-value').addClass('evidenziato')
        } else {
          $('#nome-cognome-value').removeClass('evidenziato')
        }
        if($('input[name="ruolo"]:focus').length){
          $('#ruolo-value').addClass('evidenziato')
        } else {
          $('#ruolo-value').removeClass('evidenziato')
        }
        if($('input[name="interno"]:focus').length){
          $('#interno-value').addClass('evidenziato')
        } else {
          $('#interno-value').removeClass('evidenziato')
        }
        if($('input[name="cellulare"]:focus').length){
          $('#numero-cellulare-value').addClass('evidenziato')
        } else {
          $('#numero-cellulare-value').removeClass('evidenziato')
        }
     });

     $('.gestione-input input').on('blur', function(){
        if($('input[name="name"]:focus').length){
          $('#nome-cognome-value').addClass('evidenziato')
        } else {
          $('#nome-cognome-value').removeClass('evidenziato')
        }
        if($('input[name="ruolo"]:focus').length){
          $('#ruolo-value').addClass('evidenziato')
        } else {
          $('#ruolo-value').removeClass('evidenziato')
        }
        if($('input[name="interno"]:focus').length){
          $('#interno-value').addClass('evidenziato')
        } else {
          $('#interno-value').removeClass('evidenziato')
        }
        if($('input[name="cellulare"]:focus').length){
          $('#numero-cellulare-value').addClass('evidenziato')
        } else {
          $('#numero-cellulare-value').removeClass('evidenziato')
        }
     });

     function download(filename, text) {
      var element = document.createElement('a');
      element.setAttribute('href', 'data:text/plain;charset=utf-8,' + encodeURIComponent(text));
      element.setAttribute('download', filename);

      element.style.display = 'none';
      document.body.appendChild(element);

      element.click();

      document.body.removeChild(element);
    }


     $('#scarica-la-tua-firma').on('click', function(){
      let nomeInserito = $('input[name="name"]').val();
      let ruoloInserito = $('input[name="ruolo"]').val();
      let internoInserito = $('input[name="interno"]').val();
      let cellulareInserito = $('input[name="cellulare"]').val();
      if (!(nomeInserito)){
        nomeInserito = 'Nome Cognome';
      }  
      if (!(ruoloInserito)){
        ruoloInserito = 'Ruolo';
      }

      let immagineInserita = false;
      if($('#immagine-banner-firma').is(':checked')){
        immagineInserita = 'si';
      } 
      /* if (!(internoInserito)){
        internoInserito = 'XX';
      } 
      if (!(cellulareInserito)){
        cellulareInserito = 'XXX XXXXXXX';
      } */
      cellulareInserito = cellulareInserito.replace(/ /g,"&nbsp;");
      // Scarica il file della firma, nel nome e cognome inseriti dall'utente sostituisci gli spazi con _
      download(`${nomeInserito.replace(/ /g,"_").toLowerCase()}_firma_microtest_spa.htm`,`<!DOCTYPE html><html>
  <head>
    <meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<meta name="viewport" content="width=device-width,initial-scale=1">
		<meta name="format-detection" content="telephone=yes, date=no, address=no, email=no">
		<meta name="x-apple-disable-message-reformatting">
  <\/head>
  <style>
  @import url('https:\/\/fonts.googleapis.com\/css2?family=Barlow:wght@300;400;600;700&display=swap');
  *{font-family: 'Barlow', sans-serif;}
  <\/style>
  <body>
  <table cellspacing="0" cellpadding="0" border="0">
      <tr>
        <td width="460" valign="top" style="padding-left: 0px; padding-top: 0px; padding-bottom: 0px; padding-right: 0px;">
        <span style="text-align: left; color: #4A4A4A; font-family: 'Barlow', Arial, sans-serif; font-size: 14pt; font-weight: bold; font-style: normal;" id="nome-cognome-value"><font face="'Barlow', Arial, sans-serif;">${nomeInserito}<\/font><\/span><br>
        <span style="text-align: left; margin-top: 0px; margin-bottom: 0px; color: #4A4A4A; font-family: 'Barlow', Arial, sans-serif; font-weight: normal; font-size: 12pt;" id="ruolo-value"><font face="'Barlow', Arial, sans-serif;">${ruoloInserito}<\/font><\/span><br>
        <\/td>
      <\/tr>
      <tr>
        <td valign="top" style="padding-left: 0px; padding-top: 15px; padding-bottom: 10px; padding-right: 0px;">
        <a href="http:\/\/www.microtest.net\/" target="_blank"><img src="https:\/\/www.microtest.net\/firmamail\/Microtest_Firma_mail_payoff.png" nosend="1" border="0" width="250" alt="Microtest" title="Microtest"><\/a>
        <\/td>
      <\/tr>

      <tr>
        <td valign="top" style="padding-left: 0px; padding-top: 0px; padding-bottom: 0px; padding-right: 0px;">
          <span style="text-align: left; color: #4A4A4A; font-family: 'Barlow', Arial, sans-serif; font-size: 9pt; font-style: normal; font-weight: normal;">
            <font face="'Barlow', Arial, sans-serif;">Via della Galeotta 9\/A <\/font><span style="color:#009739;text-align: left; font-family: 'Barlow', Arial, sans-serif; font-size: 9pt; font-style: normal; font-weight: normal;">|<\/span>  <font face="'Barlow', Arial, sans-serif;">55011 – Altopascio, Lucca – Italy<\/font> <br>
            <span style="color:#009739;text-align: left; font-family: 'Barlow', Arial, sans-serif; font-size: 9pt; font-style: normal; font-weight: normal;"> <font face="'Barlow', Arial, sans-serif;">direct phone<\/font> <\/span> <a href="tel:+390583269651" target="_blank" style="color: #4A4A4A; text-decoration: none; font-size: 9pt; font-family: 'Barlow', Arial, sans-serif;"><font face="'Barlow', Arial, sans-serif;">+39 0583 269651<\/font><\/a> 

            ${internoInserito ? `<font face="'Barlow', Arial, sans-serif;">ext. <\/font><span id="interno-value" style="text-align: left; color: #4A4A4A; font-family: 'Barlow', Arial, sans-serif; font-size: 9pt; font-style: normal; font-weight: normal;"><font face="'Barlow', Arial, sans-serif;">${internoInserito}<\/font><\/span>` : ''}

            ${cellulareInserito ? `<span style="color:#009739;text-align: left; font-family: 'Barlow', Arial, sans-serif; font-size: 9pt; font-style: normal; font-weight: normal;"> | <font face="'Barlow', Arial, sans-serif;"> mobile<\/font>&nbsp;<\/span><font face="'Barlow', Arial, sans-serif;">(+39)<\/font>&nbsp;<a href="tel:+39${cellulareInserito}" id="link-cellulare" style="color: #4A4A4A; text-decoration: none; font-size: 9pt; font-family: 'Barlow', Arial, sans-serif;" target="_blank"><font face="'Barlow', Arial, sans-serif;"><span id="numero-cellulare-value" style="text-align: left; color: #4A4A4A; font-family: 'Barlow', Arial, sans-serif; font-size: 9pt; font-style: normal; font-weight: normal;"><font face="'Barlow', Arial, sans-serif;">${cellulareInserito}<\/font><\/span><\/font><\/a>` : ''}
            
            <\/span>
        <\/td>
      <\/tr>

      <tr>
        <td valign="top" style="padding-left: 0px; padding-top: 10px; padding-bottom: 0px; padding-right: 0px;"><table width="460" border="0">
            <tr>
              <td width="30" align="left"><a href="https:\/\/www.linkedin.com\/company\/microtest-srl\/" target="_blank"><img src="https:\/\/www.microtest.net\/firmamail\/Microtest_Firma_mail_payoff-linkedin.png" alt="LinkedIn" width="20" height="20" border="0"><\/a><\/td>
              <td width="30" align="left"><a href="http:\/\/www.youtube.com\/c\/Microtestmovies" target="_blank"><img src="https:\/\/www.microtest.net\/firmamail\/Microtest_Firma_mail_payoff-youtube.png"  alt="YouTube" width="20" height="20" border="0"><\/a><\/td>
              <td><a style="text-decoration: none; color: #009739; font-family: 'Barlow', Arial, sans-serif; font-style: 13; font-weight: bold; valign: centre;" href="http:\/\/www.microtest.net" target="_blank"><font color="#009739" face="'Barlow', Arial, sans-serif;">www.microtest.net<\/font><\/a> <\/td>
            <\/tr>
        <\/table> 

        ${immagineInserita ? `<table width="" border="0" style="margin-top: 5px;padding-top:5px">
              <tr>
                <td>

                <a style="text-decoration: none; color: #009739; font-family: 'Barlow', Arial, sans-serif; font-style: 13; font-weight: bold; valign: centre;" href="https://\/\/twepp24.org/\/" target="_blank">
                  <img src="https:\/\/www.microtest.net\/firmamail\/banner\/firma-twepp-2024-min.png" width="500" height="150" style="width:500px; height:156px;" alt="Microtest Group at TWEPP 2024 – Advancing Electronics for Particle Physics - September 30th to October 4th, 2024"> 
                  <\/a>
                <\/td> 
              <\/tr>
          <\/table>   ` : ''}
        
          <hr noshade="noshade" color="#009739">
        <\/td>
      <\/tr>
      <tr>
        <td valign="top" style="padding-left: 0px; padding-top: 0px; padding-bottom: 0px; padding-right: 0px;">
        <span style="color: #8A8A8A; font-family: 'Barlow', Arial, sans-serif; font-size: 8pt; font-weight: regular;"><font color="#8A8A8A" face="'Barlow', Arial, sans-serif;">This email and any files attached are proprietary, confidential and intended exclusively for use by the individual or entity to whom they are dispatched. <br\/>
        If you are not the intended recipient, please delete the email and notify the sender.<\/font><\/span>
        <\/td>
      <\/tr>

    <\/table>
  <\/body>
<\/html>
`);

     });

  });
</script>
<?php get_footer();
