<?php
/*
*Template Name: General Purpose
*@link https://codex.wordpress.org/Template_Hierarchy
*@package Microtest
*/

get_header();

$args = array( 
  'post_type' => 'applications'
);

$query = new WP_Query($args);
$apps = array();

while( $query->have_posts() ) {
  $query->the_post();
  array_push( 
    $apps, 
    array( 
      'title' => get_the_title(), 
      'icona' => get_field( 'icona_verde' ),
      'id'    => get_the_ID(),
      'link'  => get_the_permalink(),
    )
  );
}

wp_reset_postdata();
?>

<main id="content" class="main-general-purpose">
  <div class="the-title">
    <h2><?php the_title(); ?></h2>
  </div>
  <section class="section-1">
    <div class="container">
      <div class="row">
        <div class="col-12 col-md-6 block-left">
        </div>
        <div class="col-12 col-md-6  block-right">
          <?php echo get_field('section_1'); ?>
          <div id="applications" class="row">
            <h4 class="apps-title">
              <?php _e("Applications", "microtest"); ?>
            </h4>
            <div class="applicationsContainer">
                <?php foreach($apps as $app) : ?>
                  <a href="<?= $app['link'] ?>">
                    <div class="app-img">
                      <img src="<?= $app['icona'] ?>">
                      <figcaption class="figure-caption app-text"><?= $app['title'] ?></figcaption>
                    </div>
                  </a>
                <?php endforeach ?>
            </div>
          </div>
          <?php $linguaAttuale = ICL_LANGUAGE_CODE; ?>
          <div class="sezione-form form-servizi" style="margin-bottom: 30px;">
            <?php if($linguaAttuale === 'en' || $linguaAttuale === 'zh-hans') { ?>
              <?php echo do_shortcode('[contact-form-7 id="dfc4f85" title="Contacts EN"]') ?>
            <?php } ?> 
            <?php if($linguaAttuale === 'it') { ?>
              <?php echo do_shortcode('[contact-form-7 id="73e3489" title="Contacts IT"]') ?>
            <?php } ?>
          </div>
        </div>
      </div>
    </div>
  </section>
  <section class="section-2">
    <div class="container-fluid">
        <?php echo get_field('section_2'); ?>
    </div>
  </section>
</main>

<?php get_footer();